using UnityEngine;
using System.Collections;
using System.Collections.Generic;
 

public class hv_script : MonoBehaviour {
	
	public GameObject floating01;
	public GameObject floating02;
	public GameObject floating03;
	
	public GameObject healthPlane;
	public float totalHealthPoint;
	private float ratioHealthPoint;
	public Texture[] healthPointTexture;
	
	
	public GameObject bigSphere;
	
	public GameObject instanceExplodeHV;
	public List<GameObject> destroyTriangles = new List<GameObject>();

	private float speed01 = 0.5f;
	private float speed02 = 1.5f;
	private float speed03 = 1.0f;
	
	// Use this for initialization
	void Start () {
		ratioHealthPoint 	= totalHealthPoint/4;
	}
	
	// Update is called once per frame
	void Update () {
		
		if( bigSphere != null)
		{
			bigSphere.transform.RotateAroundLocal( Vector3.up, Time.deltaTime * 0.1f);
		}
		if( floating01 != null)
		{
			floating01.transform.RotateAroundLocal( Vector3.up, Time.deltaTime * speed01);
			floating02.transform.RotateAroundLocal( Vector3.up, Time.deltaTime * -speed02);
			floating03.transform.RotateAroundLocal( Vector3.up, Time.deltaTime * speed03);
		}
	}
	
	// rendu des points de vie face camera
	public void upDateHealthPoint(int impactForce)
	{
		totalHealthPoint -= impactForce;
				
		if( totalHealthPoint < ratioHealthPoint || totalHealthPoint < 0)
		{
			instanceExplosion();
		}
		if(ratioHealthPoint * 1 < totalHealthPoint && totalHealthPoint < ratioHealthPoint * 2){ healthPlane.renderer.material.mainTexture = healthPointTexture[3];}
		if(ratioHealthPoint * 2 < totalHealthPoint && totalHealthPoint < ratioHealthPoint * 3){ healthPlane.renderer.material.mainTexture = healthPointTexture[2];}
		if(ratioHealthPoint * 3 < totalHealthPoint && totalHealthPoint < ratioHealthPoint * 4){	healthPlane.renderer.material.mainTexture = healthPointTexture[1];}
	}
	
	
	void instanceExplosion()
	{
		if(instanceExplodeHV != null)
		{
			Instantiate( instanceExplodeHV, transform.position, Quaternion.LookRotation(transform.position));
			StartCoroutine(destroy());
		}
	}
	
	IEnumerator destroy(){
		
		yield return new WaitForSeconds (0.75f);		
		foreach(GameObject triangles in destroyTriangles)
		{
			Destroy(triangles);
		}
		GameObject.Find("Camera").GetComponent<planete>()._Allprops.Remove(gameObject);
		Destroy(gameObject);
	}
}
